﻿using System;
using System.Runtime.Serialization;
using System.Linq;

namespace VIRP.EFR.BO
{
    [Serializable, DataContract]
    public partial class ContactLog
    {
        #region Fields

        private int contactId;
        private string contactName;
        private string contactInitiator;
        private string contactDate;
        private string contactReason;
        private string contactText;
        private bool telemedicinePatient;
        private bool telemedicineProvider;
        private bool inpatientEvaluation;
        private bool followup;

        #endregion

        #region Constructors

        public ContactLog()
        {
        }

        #endregion

        #region Properties

        public int ContactId
        {
            get { return this.contactId; }
            set { this.contactId = value; }
        }

        public string ContactName
        {
            get { return this.contactName; }
            set { this.contactName = value; }
        }

        public string ContactInitiator
        {
            get { return this.contactInitiator; }
            set { this.contactInitiator = value; }
        }

        public string ContactDate
        {
            get { return this.contactDate; }
            set { this.contactDate = value; }
        }

        public string ContactReason
        {
            get { return this.contactReason; }
            set { this.contactReason = value; }
        }

        public string ContactText
        {
            get { return this.contactText; }
            set { this.contactText = value; }
        }

        public bool TelemedicinePatient
        {
            get { return this.telemedicinePatient; }
            set { this.telemedicinePatient = value; }
        }

        public bool TelemedicineProvider
        {
            get { return this.telemedicineProvider; }
            set { this.telemedicineProvider = value; }
        }

        public bool InpatientEvaluation
        {
            get { return this.inpatientEvaluation; }
            set { this.inpatientEvaluation = value; }
        }

        public bool Followup
        {
            get { return this.followup; }
            set { this.followup = value; }
        }

        public string ContactComments
        {
            get
            {
                return String.Join(", ", 
                    new string[] { this.telemedicinePatient ? "Telemedicine consultation with patient recommended" : String.Empty,
                        this.telemedicineProvider ? "Telemedicine consultation with provider recommended" : String.Empty,
                        this.followup ? "Follow-up needed" : String.Empty,
                        this.inpatientEvaluation ? "Inpatient Evaluation Recommended" : String.Empty }.Where(s => !String.IsNullOrEmpty(s)).ToArray());
            }
        }

        #endregion

        #region Methods
        #endregion
    }
}